close all

%% HIS suspension

% DATA
miu=1.6;
hr=1.6;
hf=0.625;
Cp=1.7*10^(-10);
Ca=3*10^(-10);
Srt=(0.05/2)^2*pi;
Z_A=3*10^8;
Z_H=7*10^8;
Z_R=7*10^8;
a=1.415;
b=3.25-1.415;
l=1.55/2;


% Stiffness Characteristic

Kb=[2*((miu-hr)^2+(hf*miu)^2)                        -2*((a*miu+b*hr)*(miu-hr)+(a*hf*miu+b)*(hf*miu)) 0;
    -2*((a*miu+b*hr)*(miu-hr)+(a*hf*miu+b)*(hf*miu)) 2*((a*miu+b*hr)^2+(a*hf*miu+b)^2)                0;
    0                                                0                                                2*((l*miu+l*hr)^2+(l*hf*miu+l)^2)];

Kbw=[-miu*(miu-hr)-hf*miu*hf*miu           -miu*(miu-hr)-hf*miu*hf*miu              hr*(miu-hr)+hf*miu            hr*(miu-hr)+hf*miu;
     miu*(a*miu+b*hr)+miu*hf*(a*hf*miu+b)  miu*(a*miu+b*hr)+miu*hf*(a*hf*miu+b)     -hf*(a*miu+b*hr)-(a*hf*miu+b) -hf*(a*miu+b*hr)-(a*hf*miu+b);
     -miu*(l*miu+l*hr)-hf*miu*(l*hf*miu+l) -(-miu*(l*miu+l*hr)-hf*miu*(l*hf*miu+l)) -hr*(l*miu+l*hr)-(l*miu*hf+l) -(-hr*(l*miu+l*hr)-(l*miu*hf+l))];

Kw=[miu^2*(hf^2+1) 0              0            -miu*(hr+hf);
    0              miu^2*(hf^2+1) -miu*(hr+hf) 0;
    0              -miu*(hr+hf)   hr^2+1       0;
    -miu*(hr+hf)   0              0            hr^2+1];

K_HIS=1/(Cp+Ca)*[Kb Kbw; Kbw' Kw]*Srt^2;

% Damping Characteristic

i=0;

Cb_0=[2*(hf^i*miu^2+hr^i)      -2*(a*hf^i*miu^2-b*hr^i)    0;
      -2*(a*hf^i*miu^2-b*hr^i) 2*(a^2*hf^i*miu^2+b^2*hr^i) 0;
      0                        0                           2*(l^2*hf^i*miu^2+l^2*hr^i)];

Cbw_0=[-hf^i*miu^2   -hf^i*miu^2  -hr^i     -hr^i;
       a*hf^i*miu^2  a*hf^i*miu^2 -b*hr^i   -b*hr^i;
       -l*hf^i*miu^2 l*hf^i*miu^2 -l*b*hr^i l*b*hr^i];

Cw_0=[hf^i*miu^2 0          0    0;
      0          hf^i*miu^2 0    0;
      0          0          hr^i 0;
      0          0          0    hr^i];

j=2;

Cb_2=[2*(hf^j*miu^2+hr^j)      -2*(a*hf^j*miu^2-b*hr^j)    0;
      -2*(a*hf^j*miu^2-b*hr^j) 2*(a^2*hf^j*miu^2+b^2*hr^j) 0;
      0                        0                           2*(l^2*hf^j*miu^2+l^2*hr^j)];

Cbw_2=[-hf^j*miu^2   -hf^j*miu^2  -hr^j     -hr^j;
       a*hf^j*miu^2  a*hf^j*miu^2 -b*hr^j   -b*hr^j;
       -l*hf^j*miu^2 l*hf^j*miu^2 -l*b*hr^j l*b*hr^j];

Cw_2=[hf^j*miu^2 0          0    0;
      0          hf^j*miu^2 0    0;
      0          0          hr^j 0;
      0          0          0    hr^j];

Kco=[Kb Kbw; Kbw' Kw]*Srt^2;

C_HIS=Z_A*Kco+Z_H*[Cb_0 Cbw_0; Cbw_0' Cw_0]*Srt^2+Z_R*[Cb_2 Cbw_2; Cbw_2' Cw_2]*Srt^2;

